unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Buttons, StdCtrls, AppEvnts;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    Panel2: TPanel;
    Label1: TLabel;
    ApplicationEvents1: TApplicationEvents;
    btnCzas: TButton;
    Timer1: TTimer;
    Label2: TLabel;
    procedure Timer1Timer(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);

  private

  public
	 procedure  DrawOnButton();
	 procedure  DrawOnPanel();
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm1.ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);
begin
	DrawOnButton();
   DrawOnPanel();
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
	Close();
end;

procedure TForm1.DrawOnButton();
var
   h        : HWND;
   dc       : HDC;
   canv     : TCanvas;
   txt      : String;
   kolor    : TColor;
   x        : Integer;
   y        : Integer;

begin
	txt := 'Text na Button1';
	x   := 0;
   y   := 0;

   // uchwyt okna - klawisz Button1
   h  := Button1.Handle;
   // kontekst urzdzenia
   dc := GetDC(h);

	// nowy Canvas
	canv := TCanvas.Create();
   // uchwytem Canvas jest - Button1.Canvas
   canv.Handle := dc;


   y := Button1.Height div 2;
   y := y - canv.TextHeight(txt);
   x := (Button1.Width - canv.TextWidth(txt)) div 2;

   // pobieramy prbk koloru
   kolor := canv.Pixels[x, y];

   canv.Brush.Color := kolor;
   canv.TextOut(x, y, txt);

   FreeAndNil(canv);

   ReleaseDC(h, dc);
end;

procedure TForm1.DrawOnPanel();
var
	h      : HWND;
   dc     : HDC;
   canv   : TCanvas;
   txt    : String;
	kolor  : TColor;
	x      : Integer;
   y      : Integer;
   szer   : Integer;

begin
	{
   wywietla czas na Panel2
	}
	x := 0;
	y := 0;

	// uchwyt okna - Panel2
   h  := Panel2.Handle;
   // kontekst urzdzenia
   dc := GetDC(h);

	// nowy Canvas
	canv := TCanvas.Create();
   // uchwytem Canvas jest - Panel2.Canvas
   canv.Handle := dc;

   szer := canv.TextWidth(Label1.Caption);
   txt  := 'Text na Panel2';

	x := Label1.Left + szer + 5;
   y := Label1.Top;

   // pobieramy prbk koloru z miejsca gdzie bdzie wywietlany tekst
   kolor := canv.Pixels[x, y];

   canv.Brush.Color := kolor;
   canv.TextOut(x, y, txt);


   FreeAndNil(canv);
   ReleaseDC(h, dc);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
   h      : HWND;
   dc     : HDC;
   canv   : TCanvas;
   txt    : String;
   kolor  : TColor;
   x      : Integer;
   y      : Integer;
   szer   : Integer;

begin
	x := 0;
   y := 0;

   // uchwyt okna - klawisza btnCzas
   h := btnCzas.Handle;
   // kontekst urzdzenia
   dc := GetDC(h);

   // nowy Canvas
   canv := TCanvas.Create();
   // uchwytem Canvas jest btnczas
   canv.Handle := dc;

   txt := TimeToStr(Time());
   szer := canv.TextWidth(txt);

   x := 5;
   y := 5;
   // pobieramy prbk koloru z btnCzas
   // UWAGA:
   // W Win XP, Vista kolor moe nie by taki jak trzeb poniewaz
   // przysiski s cieniowane
   kolor := canv.Pixels[x, y];

   canv.Brush.Color := kolor;

   x := 5;
   y := 5;
   canv.TextOut(x, y, txt);

   FreeAndNil(canv);
   ReleaseDC(h, dc);
end;

end.

